''*************************************
''*  NTSC Video Overlay Test Program  *
''*      (C) 2006 Hitt Consulting     *
''*      terry@hittconsulting.com     *
''*************************************

' Used to test "HITT_Video_Overlay_010" object


CON
  _clkmode        = xtal1 + pll8x
  _xinfreq        = 5_000_000


OBJ
  Overlay: "HITT_Video_Overlay_010"


VAR
  LONG temp

  
PUB Start
  Overlay.Init

  Overlay.MoveTo(8, 8)
  Overlay.PutStrBig(STRING("HITT CONSULTING"))
  Overlay.MoveTo(20, 40)
  Overlay.PutStrBig(STRING("Video Overlay"))
  
  Overlay.MoveTo(0, 168)
  Overlay.PutStr(STRING(" 01/01/06  13:45   SPD:  123.4"))
  Overlay.MoveTo(0, 176)
  Overlay.PutStr(STRING(" LAT:  1234.5678   HDG:  123.4"))
  Overlay.MoveTo(0, 184)
  Overlay.PutStr(STRING(" LONG:12345.6789   ALT:12345.6"))

  Overlay.SetMode(2)
  REPEAT temp FROM 90 TO 10 STEP 10
    Overlay.Disc(128, 95, temp)
  
  REPEAT
    REPEAT temp FROM 0 TO 255
      Overlay.Line(temp, 0, 255-temp, 191)
      WaitCnt(200000+Cnt)
      Overlay.Line(temp, 0, 255-temp, 191)

    REPEAT temp FROM 191 TO 0
      Overlay.Line(0, temp, 255, 191-temp)
      WaitCnt(200000+Cnt)
      Overlay.Line(0, temp, 255, 191-temp)
      
    